/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EipAps_Public.h 56088 2015-09-09 12:44:58Z kai $:

Description:
  EtherNet/IP AP task
  Public definitions

Changes:
 Date          Description
 -----------------------------------------------------------------------------------
 2006-12-15    created
**************************************************************************************/

#ifndef __EIP_DPMINTF_PUBLIC_H
#define __EIP_DPMINTF_PUBLIC_H

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(EIP_DPMINTF_PUBLIC)
#endif

/***************************************************************************************/
/* Eip DpmIntf public, constants */

#define EIP_DPMINTF_PROCESS_QUEUE_NAME       "DPMINTF_QUE"
/***************************************************************************************/

#define EIP_APS_WARMSTART_PRM_REQ         0x00003600
#define EIP_APS_WARMSTART_PRM_CNF         0x00003601

/*! \addtogroup EIP_APS_CLEAR_WATCHDOG_REQ_Content
 * \{ */
#define EIP_APS_CLEAR_WATCHDOG_REQ        0x00003602
#define EIP_APS_CLEAR_WATCHDOG_CNF        0x00003603
/*! \}*/
/*! \addtogroup EIP_APS_REGISTER_APP_REQ_Content
 * \{ */
#define EIP_APS_REGISTER_APP_REQ          0x00003604
#define EIP_APS_REGISTER_APP_CNF          0x00003605
/*! \}*/
/*! \addtogroup EIP_APS_UNREGISTER_APP_REQ_Content
 * \{ */
#define EIP_APS_UNREGISTER_APP_REQ        0x00003606
#define EIP_APS_UNREGISTER_APP_CNF        0x00003607
/*! \}*/
/*! \addtogroup EIP_APS_SET_CONFIGURATION_REQ_Content
 * \{ */

#define EIP_APS_SET_CONFIGURATION_REQ_OLD 0x00003608 /* This command is deprecated. Please use command
                                                        0x00003612 (EIP_APS_SET_CONFIGURATION_PARAMETERS_REQ) instead */
#define EIP_APS_SET_CONFIGURATION_CNF_OLD 0x00003609 /* This command is deprecated. Please use command
                                                        0x00003613 (EIP_APS_SET_CONFIGURATION_PARAMETERS_CNF) instead */
/*! \}*/

/*! \addtogroup EIP_APS_SET_PARAMETER_REQ_Content
 * \{ */
#define   EIP_APS_SET_PARAMETER_REQ       0x0000360A
#define   EIP_APS_SET_PARAMETER_CNF       0x0000360B
/*! \}*/

/*! \addtogroup EIP_APS_MS_NS_CHANGE_IND_Content
 * \{ */
#define   EIP_APS_MS_NS_CHANGE_IND        0x0000360C
#define   EIP_APS_MS_NS_CHANGE_RES        0x0000360D
/*! \}*/

/*! \addtogroup EIP_APS_GET_MS_NS_REQ_Content
 * \{ */
#define   EIP_APS_GET_MS_NS_REQ           0x0000360E
#define   EIP_APS_GET_MS_NS_CNF           0x0000360F
/*! \}*/

#define   EIP_APS_ACD_LIMIT_RATE_TIMER_IND   0x00003610
#define   EIP_APS_ACD_LIMIT_RATE_TIMER_RES   0x00003611

#define EIP_APS_SET_CONFIGURATION_PARAMETERS_REQ     0x00003612
#define EIP_APS_SET_CONFIGURATION_PARAMETERS_CNF     0x00003613

/*
 * Reserved for EtherNet/IP V3
 * #define EIP_APS_CONFIG_DONE_REQ           0x00003614
 * #define EIP_APS_CONFIG_DONE_CNF           0x00003615
*/


/***************************************************************************************/
/* Warmstart System Flags */
#define WSTART_SYSFLAG_START_MSK            0x00000001
#define WSTART_SYSFLAG_START_APPLICATION    0x00000001
#define WSTART_SYSFLAG_START_AUTO           0x00000000

#define WSTART_SYSFLAG_IOSTAT_ENABLE_MSK    0x00000002
#define WSTART_SYSFLAG_IOSTAT_ENABLED_MSK   0x00000002
#define WSTART_SYSFLAG_IOSTAT_DISABLED_MSK  0x00000000

#define WSTART_SYSFLAG_IOSTAT_LEN_MSK       0x00000004
#define WSTART_SYSFLAG_IOSTAT_LEN_8BIT      0x00000000
#define WSTART_SYSFLAG_IOSTAT_LEN_32BIT     0x00000004

/***************************************************************************************/
/* Eip DpmIntf public, types */

/*#####################################################################################*/
/*#####################################################################################*/

typedef __PACKED_PRE struct EIP_APS_WARMSTART_PRM_REQ_Ttag{

  TLR_UINT32  ulSystemFlags; /* Reserved for IO status */
  TLR_UINT32  ulWdgTime;     /* Watch dog time in msec <br>
                                Default value: 1000 <br>
                                Allowed value: 20 - 65535 <br>
                                Value 0 switches off the watch dog */
  TLR_UINT32  ulInputLen;    /* Size of input data */
  TLR_UINT32  ulOutputLen;   /* Size of output data */

  TLR_UINT32  ulTcpFlag;     /* TCP/IP flags    */
  TLR_UINT32  ulIpAddr;      /* IP address      */
  TLR_UINT32  ulNetMask;     /* Network mask    */
  TLR_UINT32  ulGateway;     /* Gateway address */

  TLR_UINT16  usVendId;         /* Vendor ID       */
  TLR_UINT16  usProductType;    /* Product Type    */
  TLR_UINT16  usProductCode;    /* Product Code    */
  TLR_UINT8   bMinorRev;        /* Minor Revision  */
  TLR_UINT8   bMajorRev;        /* Major Revision  */
  TLR_UINT8   abDeviceName[32]; /* Product Name    */
}__PACKED_POST  EIP_APS_WARMSTART_PRM_REQ_T;

typedef struct EIP_APS_PACKET_WARMSTART_PRM_REQ_Ttag{
  TLR_PACKET_HEADER_T         tHead;
  EIP_APS_WARMSTART_PRM_REQ_T tData;
}EIP_APS_PACKET_WARMSTART_PRM_REQ_T;

#define EIP_APS_WARMSTART_PRM_REQ_SIZE (sizeof(EIP_APS_WARMSTART_PRM_REQ_T))

#define EIP_APS_WARMSTART_PRM_CNF_SIZE 0

typedef struct EIP_APS_PACKET_WARMSTART_PRM_CNF_Ttag{
  TLR_PACKET_HEADER_T tHead;
} EIP_APS_PACKET_WARMSTART_PRM_CNF_T;

/*#####################################################################################*/
/*#####################################################################################*/

/*! \defgroup EIP_APS_CLEAR_WATCHDOG_REQ_Content Command related contents
 *  \ingroup EIP_APS_CLEAR_WATCHDOG_REQ
 * \{ */

/* Clear Watchdog Message */
typedef struct EIP_APS_PACKET_CLEAR_WATCHDOG_REQ_Ttag{
  TLR_PACKET_HEADER_T tHead;
} EIP_APS_PACKET_CLEAR_WATCHDOG_REQ_T;

#define EIP_APS_CLEAR_WATCHDOG_REQ_SIZE 0

typedef struct EIP_APS_PACKET_CLEAR_WATCHDOG_CNF_Ttag{
  TLR_PACKET_HEADER_T tHead;
} EIP_APS_PACKET_CLEAR_WATCHDOG_CNF_T;

#define EIP_APS_CLEAR_WATCHDOG_CNF_SIZE 0
  /* \} */
/*#####################################################################################*/
/*#####################################################################################*/

/*! \defgroup EIP_APS_REGISTER_APP_REQ_Content Command related contents
 *  \ingroup EIP_APS_REGISTER_APP_REQ
 * \{ */

typedef struct EIP_APS_PACKET_REGISTER_APP_REQ_Ttag{
  TLR_PACKET_HEADER_T tHead;
} EIP_APS_PACKET_REGISTER_APP_REQ_T;

#define EIP_APS_REGISTER_APP_REQ_SIZE 0

typedef struct EIP_APS_PACKET_REGISTER_APP_CNF_Ttag{
  TLR_PACKET_HEADER_T tHead;
} EIP_APS_PACKET_REGISTER_APP_CNF_T;

#define EIP_APS_REGISTER_APP_CNF_SIZE 0

/* \} */
/*#####################################################################################*/
/*#####################################################################################*/

/*! \defgroup EIP_APS_UNREGISTER_APP_REQ_Content Command related contents
 *  \ingroup EIP_APS_UNREGISTER_APP_REQ
 * \{ */

#define EIP_UNREGISTER_FORCE              0x00000001

typedef __PACKED_PRE struct EIP_APS_UNREGISTER_APP_REQ_Ttag{
  TLR_UINT32   ulFlag; /*!< Force Flag:\n

                            \valueRange
                            0, 1

                            \description
                            If this flag is set to 1, unregistering
                            will take place, even if another application was
                            currently registered. The foreign application will then be
                            unregistered. If this flag is set to 0, unregistering will only
                            take place if your application was currently registered. */

}__PACKED_POST  EIP_APS_UNREGISTER_APP_REQ_T;

typedef struct EIP_APS_PACKET_UNREGISTER_APP_REQ_Ttag{
  TLR_PACKET_HEADER_T           tHead;
  EIP_APS_UNREGISTER_APP_REQ_T  tData;
} EIP_APS_PACKET_UNREGISTER_APP_REQ_T;

#define EIP_APS_UNREGISTER_APP_REQ_SIZE sizeof(EIP_APS_UNREGISTER_APP_REQ_T)

typedef struct EIP_APS_PACKET_UNREGISTER_APP_CNF_Ttag{
  TLR_PACKET_HEADER_T tHead;
} EIP_APS_PACKET_UNREGISTER_APP_CNF_T;

#define EIP_APS_UNREGISTER_APP_CNF_SIZE 0
/* \} */
/*#####################################################################################*/
/*#####################################################################################*/

/*! \defgroup EIP_APS_SET_CONFIGURATION_REQ_Content Command related contents
 *  \ingroup EIP_APS_SET_CONFIGURATION_REQ
 * \{ */

typedef __PACKED_PRE struct EIP_DPMINTF_QOS_CONFIG_Ttag
{
  TLR_UINT32    ulQoSFlags;
  TLR_UINT8     bTag802Enable;        /* QoS Attribute 1 */
  TLR_UINT8     bDSCP_PTP_Event;      /* QoS Attribute 2 */
  TLR_UINT8     bDSCP_PTP_General;    /* QoS Attribute 3 */
  TLR_UINT8     bDSCP_Urgent;         /* QoS Attribute 4 */
  TLR_UINT8     bDSCP_Scheduled;      /* QoS Attribute 5 */
  TLR_UINT8     bDSCP_High;           /* QoS Attribute 6 */
  TLR_UINT8     bDSCP_Low;            /* QoS Attribute 7 */
  TLR_UINT8     bDSCP_Explicit;       /* QoS Attribute 8 */
} __PACKED_POST EIP_DPMINTF_QOS_CONFIG_T;

typedef __PACKED_PRE struct EIP_DPMINTF_TI_ACD_LAST_CONFLICT_Ttag
{
  TLR_UINT8    bAcdActivity;      /*!< State of ACD activity when last
                                       conflict detected */

  TLR_UINT8    abRemoteMac[6];    /*!< MAC address of remote node from
                                       the ARP PDU in which a conflict was
                                       detected */

  TLR_UINT8    abArpPdu[28];      /*!< Copy of the raw ARP PDU in which
                                       a conflict was detected. */
} __PACKED_POST EIP_DPMINTF_TI_ACD_LAST_CONFLICT_T;


#define EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE    0x00000001  /*!< If set, the Quick Connect Attribute 12
                                                                   of the Tcp Interface Object (0xF5) is
                                                                   activated */

#define EIP_OBJECT_QC_FLAGS_ENABLE_QC             0x00000002  /*!< This flags sets the value of the Quick Connect Attribute.\n\n

                                                                   If set, Quick Connect is enabled.\n
                                                                   If not set, Quick Connect is disabled\n\n

                                                                   <b>Note:</b>\n

                                                                   This flag has only an effect if EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE is set simultaneously. */

typedef __PACKED_PRE struct EIP_APS_SET_CONFIGURATION_REQ_Ttag{
  TLR_UINT32  ulSystemFlags;    /*!< Reserved for IO status */
  TLR_UINT32  ulWdgTime;        /*!< Watch dog time (in milliseconds) <br>

                                     \valueRange
                                     0, 20...65535\n
                                     Default: 1000

                                     \description
                                     Value 0 switches off the watch dog */

  TLR_UINT32  ulInputLen;       /*!< Length of input data (Input Assembly)\n

                                     \valueRange
                                     0...504 \n
                                     Default: 16

                                     \description
                                     Defines the input data size and corresponds directly
                                     to the input assembly instance provided by ulInputAssInstance */
  TLR_UINT32  ulOutputLen;      /*!< Length of Output data (Output Assembly)\n

                                     \valueRange
                                     0...504 \n
                                     Default: 16

                                     \description
                                     Defines the output data size and corresponds directly
                                     to the input assembly instance provided by ulOutputAssInstance */

  TLR_UINT32  ulTcpFlag;        /*!< TCP configuration flags\n

                                     \valueRange
                                     Default: 0x00000410 (DHCP and Auto-Negotiation)

                                     \description
                                     For further information see TCPIP-Manual */
  TLR_UINT32  ulIpAddr;         /*!< IP address \n
                                     \valueRange
                                     All valid IP addresses\n
                                     Default: 0.0.0.0 */
  TLR_UINT32  ulNetMask;        /*!< Network mask \n

                                     \valueRange
                                     All valid masks\n
                                     Default: 0.0.0.0 */
  TLR_UINT32  ulGateway;        /*!< Gateway address \n

                                     \valueRange
                                     All valid IP addresses\n
                                     Default: 0.0.0.0 */

  TLR_UINT16  usVendId;         /*!< CIP vendor identification \n

                                     \valueRange
                                     1...65535 \n
                                     Default: 283 (Hilscher GmbH)

                                     \description
                                     This is an identification number for
                                     the manufacturer of an EtherNet/IP device.
                                     Vendor IDs are managed by ODVA.
                                     The value zero is not valid */
  TLR_UINT16  usProductType;    /*!< CIP device type \n

                                     \valueRange
                                     Publicly defined: 0x00 - 0x64    \n
                                     Vendor specific: 0x64 - 0xC7     \n
                                     Reserved by CIP: 0xC8 - 0xFF     \n
                                     Publicly defined: 0x100 - 0x2FF  \n
                                     Vendor specific: 0x300 - 0x4FF   \n
                                     Reserved by CIP: 0x500 - 0xFFFF  \n\n
                                     Default: 0x0C (Communication Device)

                                     \description
                                     The list of device types is managed by ODVA.
                                     It is used to identify the device profile that a
                                     particular product is using. Device profiles
                                     define minimum requirements a device must
                                     implement as well as common options. */
  TLR_UINT16  usProductCode;    /*!< Product code \n

                                     \valueRange
                                     1...65535

                                     \description
                                     The vendor assigned Product Code identifies a particular product within a device type. Each
                                     vendor assigns this code to each of its products. The Product Code typically maps to one or
                                     more catalog/model numbers. Products shall have different codes if their configuration and/or
                                     runtime options are different. Such devices present a different logical view to the network. On
                                     the other hand for example, two products that are the same except for their color or mounting
                                     feet are the same logically and may share the same product code.
                                     The value zero is not valid. */

  TLR_UINT32  ulSerialNumber;   /*!< Serial number \n

                                     \valueRange
                                     0x00000000... 0xFFFFFFFF

                                     \description
                                     This attribute is a number used in conjunction with the Vendor ID to form a unique identifier
                                     for each device on any CIP network. Each vendor is responsible for guaranteeing the
                                     uniqueness of the serial number across all of its devices. \n
                                     Usually, this number will be set automatically by the firmware,
                                     if a security memory is available. */

  TLR_UINT8   bMinorRev;        /*!< Minor revision \n

                                     \valueRange
                                     1...255 */

  TLR_UINT8   bMajorRev;        /*!< Major revision \n

                                     \valueRange
                                     1...127 */

  TLR_UINT8   abDeviceName[32]; /*!< Device name\n

                                     \description
                                     This text string should represent a short description of the product/product family represented
                                     by the product code. The same product code may have a variety of product name
                                     strings.\n\n
                                     The first byte indicates the name length, byte
                                     2-31 contain the actual characters of the device name.*/

  TLR_UINT32  ulInputAssInstance;   /*!< Instance number of input assembly\n

                                     \valueRange \n\n
                                     Instances of the Assembly Object are divided into the following address ranges to \n
                                     provide for extensions to device profiles \n\n
                                     0x00000001 - 0x00000063 : Open (static assemblies defined in device profile)       \n
                                     0x00000064 - 0x000000C7 : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x000000C8 - 0x000002FF : Open (static assemblies defined in device profile)       \n
                                     0x00000300 - 0x000004FF : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x00000500 - 0x000FFFFF : Open (static assemblies defined in device profile)      \n
                                     0x00100000 - 0xFFFFFFFF : Reserved by CIP for future use.

                                     \description
                                     This parameter defines the instance number of the input assembly.

                                     */

  TLR_UINT8   ulInputAssFlags;      /*!< Input assembly flags\n

                                      \valueRange \n

                                       - <b> Bit 0:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 1:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 2:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 3:</b> \n
                                         If set, the assembly data is modeless
                                         (i.e. it does <b>not</b> contain run/idle information) \n\n

                                       - <b> Bit 4:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 5:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 6:</b> \n
                                         This flag decides whether the data that is mapped into the
                                         DPM memory area is cleared upon closing of
                                         the connection or whether the last sent/received data is left
                                         unchanged in the memory.
                                         If the bit is set the data will be left unchanged.\n\n
                                     */


  TLR_UINT32  ulOutputAssInstance;  /*!< Instance number of output assembly\n

                                     \valueRange \n\n
                                     Instances of the Assembly Object are divided into the following address ranges to \n
                                     provide for extensions to device profiles \n\n
                                     0x00000001 - 0x00000063 : Open (static assemblies defined in device profile)       \n
                                     0x00000064 - 0x000000C7 : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x000000C8 - 0x000002FF : Open (static assemblies defined in device profile)       \n
                                     0x00000300 - 0x000004FF : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x00000500 - 0x000FFFFF : Open (static assemblies defined in device profile)      \n
                                     0x00100000 - 0xFFFFFFFF : Reserved by CIP for future use.

                                     \description
                                     This parameter defines the instance number of the output assembly.

                                     */

  TLR_UINT8   ulOutputAssFlags;     /*!< Output assembly flags\n

                                      \valueRange \n
                                      See description of ulInputAssFlags
                                     */

  EIP_DPMINTF_QOS_CONFIG_T tQoS_Config; /*!< Quality of Service \n

                                          \description

                                           This parameter set configures the Quality of Service Object
                                           (CIP Id 0x48).
                                           For more information about specific parameters see command
                                           EIP_OBJECT_CFG_QOS_REQ.

                                         */

  TLR_UINT32   ulNameServer;         /*!< Name Server 1\n

                                       \description
                                        This parameter corresponds to an entry of attribute 5 of the
                                        TCP Interface Object (CIP Id 0xF5).

                                        \valueRange \n
                                        Default value: 0.0.0.0
                                     */

  TLR_UINT32   ulNameServer_2;       /*!< Name Server 2\n

                                       \description
                                        This parameter corresponds to an entry of attribute 5 of the
                                        TCP Interface Object (CIP Id 0xF5).

                                        \valueRange \n
                                        Default value: 0.0.0.0
                                      */

  TLR_UINT8    abDomainName[48 + 2]; /*!< Domain Name\n

                                       \description
                                        This parameter corresponds to an entry of attribute 5 of the
                                        TCP Interface Object (CIP Id 0xF5).
                                        The first two bytes of the name provide the length of the name.

                                        \valueRange \n
                                        Default value: No Name ("") \n
                                        Max. name length is 48 bytes

                                      */

  TLR_UINT8    abHostName[64+2];     /*!< Host Name\n

                                       \description
                                        This parameter corresponds to attribute 6 of the
                                        TCP Interface Object (CIP Id 0xF5).
                                        The first two bytes of the name provide the length of the name.

                                        \valueRange \n
                                        Default value: No Name ("") \n
                                        Max. name length is 64 bytes
                                      */

  TLR_UINT8    bSelectAcd;           /*!< Select ACD

                                         \description
                                        This parameter corresponds to attribute 10 of the
                                        TCP Interface Object (CIP Id 0xF5).

                                        \valueRange \n
                                        1: ACD on (default) \n
                                        0: ACD off

                                      */

  EIP_DPMINTF_TI_ACD_LAST_CONFLICT_T  tLastConflictDetected; /*!< Last detected conflict\n

                                                               \description
                                                               This parameter corresponds to attribute 11 of the
                                                               TCP Interface Object (CIP Id 0xF5).

                                                               \valueRange \n
                                                               Default: All zero
                                                             */

  TLR_UINT8                           bQuickConnectFlags; /*!< Quick Connect flags \n

                                                               \description
                                                               This parameter enables/disables the Quick Connect
                                                               functionality within the stack.
                                                               This affects the TCP Interface Object (0xF5)
                                                               attribute 12. \n\n
                                                               \Note: This functionality needs special hardware settings (e.g. fast
                                                               flash)

                                                               \valueRange \n
                                                               See: \ref EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE
                                                               and  \ref EIP_OBJECT_QC_FLAGS_ENABLE_QC

                                                               <b>Examples:</b>\n\n
                                                               Do not support Quick Connect:\n
                                                               Set to zero \n\n

                                                               Support Quick Connect - Quick Connect disabled:\n
                                                               Set only flag \ref EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE
                                                               in order to activate the Quick Connect attribute within the object.\n\n

                                                               Support Quick Connect - Quick Connect enabled:\n
                                                               Set flag \ref EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE
                                                               and flag \ref EIP_OBJECT_QC_FLAGS_ENABLE_QC in order to
                                                               activate the attribute and simultaneously enable the
                                                               Quick Connection functionality.\n\n
                                                             */

}__PACKED_POST  EIP_APS_SET_CONFIGURATION_REQ_T;


#define EIP_APS_SET_CONFIGURATION_REQ_SIZE (sizeof(EIP_APS_SET_CONFIGURATION_REQ_T))


typedef struct EIP_APS_PACKET_SET_CONFIGURATION_REQ_Ttag{
  TLR_PACKET_HEADER_T             tHead;
  EIP_APS_SET_CONFIGURATION_REQ_T tData;
} EIP_APS_PACKET_SET_CONFIGURATION_REQ_T;


 #define EIP_APS_SET_CONFIGURATION_CNF_SIZE 0

typedef struct EIP_APS_PACKET_SET_CONFIGURATION_CNF_Ttag{
  TLR_PACKET_HEADER_T tHead;
} EIP_APS_PACKET_SET_CONFIGURATION_CNF_T;

/*! \} */

/*#####################################################################################*/
/*#####################################################################################*/


/*#####################################################################################*/
#define EIP_APS_CONFIGURATION_PARAMETER_SET_V1         1

typedef __PACKED_PRE struct EIP_APS_CONFIGURATION_PARAMETER_SET_V1_Ttag
{

  TLR_UINT32  ulSystemFlags;    /*!< Reserved for IO status */
  TLR_UINT32  ulWdgTime;        /*!< Watch dog time (in milliseconds) <br>

                                     \valueRange
                                     0, 20...65535\n
                                     Default: 1000

                                     \description
                                     Value 0 switches off the watch dog */

  TLR_UINT32  ulInputLen;       /*!< Length of input data (Input Assembly)\n

                                     \valueRange
                                     0...504 \n
                                     Default: 16

                                     \description
                                     Defines the input data size and corresponds directly
                                     to the input assembly instance provided by ulInputAssInstance */
  TLR_UINT32  ulOutputLen;      /*!< Length of Output data (Output Assembly)\n

                                     \valueRange
                                     0...504 \n
                                     Default: 16

                                     \description
                                     Defines the output data size and corresponds directly
                                     to the input assembly instance provided by ulOutputAssInstance */

  TLR_UINT32  ulTcpFlag;        /*!< TCP configuration flags\n

                                     \valueRange
                                     Default: 0x00000410 (DHCP and Auto-Negotiation)

                                     \description
                                     For further information see TCPIP-Manual */
  TLR_UINT32  ulIpAddr;         /*!< IP address \n
                                     \valueRange
                                     All valid IP addresses\n
                                     Default: 0.0.0.0 */
  TLR_UINT32  ulNetMask;        /*!< Network mask \n

                                     \valueRange
                                     All valid masks\n
                                     Default: 0.0.0.0 */
  TLR_UINT32  ulGateway;        /*!< Gateway address \n

                                     \valueRange
                                     All valid IP addresses\n
                                     Default: 0.0.0.0 */

  TLR_UINT16  usVendId;         /*!< CIP vendor identification \n

                                     \valueRange
                                     1...65535 \n
                                     Default: 283 (Hilscher GmbH)

                                     \description
                                     This is an identification number for
                                     the manufacturer of an EtherNet/IP device.
                                     Vendor IDs are managed by ODVA.
                                     The value zero is not valid */
  TLR_UINT16  usProductType;    /*!< CIP device type \n

                                     \valueRange
                                     Publicly defined: 0x00 - 0x64    \n
                                     Vendor specific: 0x64 - 0xC7     \n
                                     Reserved by CIP: 0xC8 - 0xFF     \n
                                     Publicly defined: 0x100 - 0x2FF  \n
                                     Vendor specific: 0x300 - 0x4FF   \n
                                     Reserved by CIP: 0x500 - 0xFFFF  \n\n
                                     Default: 0x0C (Communication Device)

                                     \description
                                     The list of device types is managed by ODVA.
                                     It is used to identify the device profile that a
                                     particular product is using. Device profiles
                                     define minimum requirements a device must
                                     implement as well as common options. */
  TLR_UINT16  usProductCode;    /*!< Product code \n

                                     \valueRange
                                     1...65535

                                     \description
                                     The vendor assigned Product Code identifies a particular product within a device type. Each
                                     vendor assigns this code to each of its products. The Product Code typically maps to one or
                                     more catalog/model numbers. Products shall have different codes if their configuration and/or
                                     runtime options are different. Such devices present a different logical view to the network. On
                                     the other hand for example, two products that are the same except for their color or mounting
                                     feet are the same logically and may share the same product code.
                                     The value zero is not valid. */

  TLR_UINT32  ulSerialNumber;   /*!< Serial number \n

                                     \valueRange
                                     0x00000000... 0xFFFFFFFF

                                     \description
                                     This attribute is a number used in conjunction with the Vendor ID to form a unique identifier
                                     for each device on any CIP network. Each vendor is responsible for guaranteeing the
                                     uniqueness of the serial number across all of its devices. \n
                                     Usually, this number will be set automatically by the firmware,
                                     if a security memory is available. */

  TLR_UINT8   bMinorRev;        /*!< Minor revision \n

                                     \valueRange
                                     1...255 */

  TLR_UINT8   bMajorRev;        /*!< Major revision \n

                                     \valueRange
                                     1...127 */

  TLR_UINT8   abDeviceName[32]; /*!< Device name\n

                                     \description
                                     This text string should represent a short description of the product/product family represented
                                     by the product code. The same product code may have a variety of product name
                                     strings.\n\n
                                     The first byte indicates the name length, byte
                                     2-31 contain the actual characters of the device name.*/

  TLR_UINT32  ulInputAssInstance;   /*!< Instance number of input assembly\n

                                     \valueRange \n\n
                                     Instances of the Assembly Object are divided into the following address ranges to \n
                                     provide for extensions to device profiles \n\n
                                     0x00000001 - 0x00000063 : Open (static assemblies defined in device profile)       \n
                                     0x00000064 - 0x000000C7 : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x000000C8 - 0x000002FF : Open (static assemblies defined in device profile)       \n
                                     0x00000300 - 0x000004FF : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x00000500 - 0x000FFFFF : Open (static assemblies defined in device profile)      \n
                                     0x00100000 - 0xFFFFFFFF : Reserved by CIP for future use.

                                     \description
                                     This parameter defines the instance number of the input assembly.

                                     */

  TLR_UINT32  ulInputAssFlags;      /*!< Input assembly flags\n

                                      \valueRange \n

                                       - <b> Bit 0:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 1:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 2:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 3:</b> \n
                                         If set, the assembly data is modeless
                                         (i.e. it does <b>not</b> contain run/idle information) \n\n

                                       - <b> Bit 4:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 5:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 6:</b> \n
                                         This flag decides whether the data that is mapped into the
                                         DPM memory area is cleared upon closing of
                                         the connection or whether the last sent/received data is left
                                         unchanged in the memory.
                                         If the bit is set the data will be left unchanged.\n\n
                                     */


  TLR_UINT32  ulOutputAssInstance;  /*!< Instance number of output assembly\n

                                     \valueRange \n\n
                                     Instances of the Assembly Object are divided into the following address ranges to \n
                                     provide for extensions to device profiles \n\n
                                     0x00000001 - 0x00000063 : Open (static assemblies defined in device profile)       \n
                                     0x00000064 - 0x000000C7 : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x000000C8 - 0x000002FF : Open (static assemblies defined in device profile)       \n
                                     0x00000300 - 0x000004FF : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x00000500 - 0x000FFFFF : Open (static assemblies defined in device profile)      \n
                                     0x00100000 - 0xFFFFFFFF : Reserved by CIP for future use.

                                     \description
                                     This parameter defines the instance number of the output assembly.

                                     */

  TLR_UINT32   ulOutputAssFlags;     /*!< Output assembly flags\n

                                      \valueRange \n
                                      See description of ulInputAssFlags
                                     */

  EIP_DPMINTF_QOS_CONFIG_T tQoS_Config; /*!< Quality of Service \n

                                          \description

                                           This parameter set configures the Quality of Service Object
                                           (CIP Id 0x48).
                                           For more information about specific parameters see command
                                           EIP_OBJECT_CFG_QOS_REQ.

                                         */

  TLR_UINT32   ulNameServer;         /*!< Name Server 1\n

                                       \description
                                        This parameter corresponds to an entry of attribute 5 of the
                                        TCP Interface Object (CIP Id 0xF5).

                                        \valueRange \n
                                        Default value: 0.0.0.0
                                     */

  TLR_UINT32   ulNameServer_2;       /*!< Name Server 2\n

                                       \description
                                        This parameter corresponds to an entry of attribute 5 of the
                                        TCP Interface Object (CIP Id 0xF5).

                                        \valueRange \n
                                        Default value: 0.0.0.0
                                      */

  TLR_UINT8    abDomainName[48 + 2]; /*!< Domain Name\n

                                       \description
                                        This parameter corresponds to an entry of attribute 5 of the
                                        TCP Interface Object (CIP Id 0xF5).
                                        The first two bytes of the name provide the length of the name.

                                        \valueRange \n
                                        Default value: No Name ("") \n
                                        Max. name length is 48 bytes

                                      */

  TLR_UINT8    abHostName[64+2];     /*!< Host Name\n

                                       \description
                                        This parameter corresponds to attribute 6 of the
                                        TCP Interface Object (CIP Id 0xF5).
                                        The first two bytes of the name provide the length of the name.

                                        \valueRange \n
                                        Default value: No Name ("") \n
                                        Max. name length is 64 bytes
                                      */

  TLR_UINT8    bSelectAcd;           /*!< Select ACD

                                         \description
                                        This parameter corresponds to attribute 10 of the
                                        TCP Interface Object (CIP Id 0xF5).

                                        \valueRange \n
                                        1: ACD on (default) \n
                                        0: ACD off

                                      */

  EIP_DPMINTF_TI_ACD_LAST_CONFLICT_T  tLastConflictDetected; /*!< Last detected conflict\n

                                                               \description
                                                               This parameter corresponds to attribute 11 of the
                                                               TCP Interface Object (CIP Id 0xF5).

                                                               \valueRange \n
                                                               Default: All zero
                                                             */

  TLR_UINT8                           bQuickConnectFlags; /*!< Quick Connect flags \n

                                                               \description
                                                               This parameter enables/disables the Quick Connect
                                                               functionality within the stack.
                                                               This affects the TCP Interface Object (0xF5)
                                                               attribute 12. \n\n
                                                               \Note: This functionality needs special hardware settings (e.g. fast
                                                               flash)

                                                               \valueRange \n
                                                               See: \ref EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE
                                                               and  \ref EIP_OBJECT_QC_FLAGS_ENABLE_QC

                                                               <b>Examples:</b>\n\n
                                                               Do not support Quick Connect:\n
                                                               Set to zero \n\n

                                                               Support Quick Connect - Quick Connect disabled:\n
                                                               Set only flag \ref EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE
                                                               in order to activate the Quick Connect attribute within the object.\n\n

                                                               Support Quick Connect - Quick Connect enabled:\n
                                                               Set flag \ref EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE
                                                               and flag \ref EIP_OBJECT_QC_FLAGS_ENABLE_QC in order to
                                                               activate the attribute and simultaneously enable the
                                                               Quick Connection functionality.\n\n
                                                             */

}__PACKED_POST  EIP_APS_CONFIGURATION_PARAMETER_SET_V1_T;

#define EIP_APS_CONFIGURATION_PARAMETER_SET_V1_SIZE (sizeof(EIP_APS_CONFIGURATION_PARAMETER_SET_V1_T) )

/*#####################################################################################*/
#define EIP_APS_CONFIGURATION_PARAMETER_SET_V2         2

typedef __PACKED_PRE struct EIP_APS_CONFIGURATION_PARAMETER_SET_V2_Ttag
{

  TLR_UINT32  ulSystemFlags;    /*!< Reserved for IO status */
  TLR_UINT32  ulWdgTime;        /*!< Watch dog time (in milliseconds) <br>

                                     \valueRange
                                     0, 20...65535\n
                                     Default: 1000

                                     \description
                                     Value 0 switches off the watch dog */

  TLR_UINT32  ulInputLen;       /*!< Length of input data (Input Assembly)\n

                                     \valueRange
                                     0...504 \n
                                     Default: 16

                                     \description
                                     Defines the input data size and corresponds directly
                                     to the input assembly instance provided by ulInputAssInstance */
  TLR_UINT32  ulOutputLen;      /*!< Length of Output data (Output Assembly)\n

                                     \valueRange
                                     0...504 \n
                                     Default: 16

                                     \description
                                     Defines the output data size and corresponds directly
                                     to the input assembly instance provided by ulOutputAssInstance */

  TLR_UINT32  ulTcpFlag;        /*!< TCP configuration flags\n

                                     \valueRange
                                     Default: 0x00000410 (DHCP and Auto-Negotiation)

                                     \description
                                     For further information see TCPIP-Manual */
  TLR_UINT32  ulIpAddr;         /*!< IP address \n
                                     \valueRange
                                     All valid IP addresses\n
                                     Default: 0.0.0.0 */
  TLR_UINT32  ulNetMask;        /*!< Network mask \n

                                     \valueRange
                                     All valid masks\n
                                     Default: 0.0.0.0 */
  TLR_UINT32  ulGateway;        /*!< Gateway address \n

                                     \valueRange
                                     All valid IP addresses\n
                                     Default: 0.0.0.0 */

  TLR_UINT16  usVendId;         /*!< CIP vendor identification \n

                                     \valueRange
                                     1...65535 \n
                                     Default: 283 (Hilscher GmbH)

                                     \description
                                     This is an identification number for
                                     the manufacturer of an EtherNet/IP device.
                                     Vendor IDs are managed by ODVA.
                                     The value zero is not valid */
  TLR_UINT16  usProductType;    /*!< CIP device type \n

                                     \valueRange
                                     Publicly defined: 0x00 - 0x64    \n
                                     Vendor specific: 0x64 - 0xC7     \n
                                     Reserved by CIP: 0xC8 - 0xFF     \n
                                     Publicly defined: 0x100 - 0x2FF  \n
                                     Vendor specific: 0x300 - 0x4FF   \n
                                     Reserved by CIP: 0x500 - 0xFFFF  \n\n
                                     Default: 0x0C (Communication Device)

                                     \description
                                     The list of device types is managed by ODVA.
                                     It is used to identify the device profile that a
                                     particular product is using. Device profiles
                                     define minimum requirements a device must
                                     implement as well as common options. */
  TLR_UINT16  usProductCode;    /*!< Product code \n

                                     \valueRange
                                     1...65535

                                     \description
                                     The vendor assigned Product Code identifies a particular product within a device type. Each
                                     vendor assigns this code to each of its products. The Product Code typically maps to one or
                                     more catalog/model numbers. Products shall have different codes if their configuration and/or
                                     runtime options are different. Such devices present a different logical view to the network. On
                                     the other hand for example, two products that are the same except for their color or mounting
                                     feet are the same logically and may share the same product code.
                                     The value zero is not valid. */

  TLR_UINT32  ulSerialNumber;   /*!< Serial number \n

                                     \valueRange
                                     0x00000000... 0xFFFFFFFF

                                     \description
                                     This attribute is a number used in conjunction with the Vendor ID to form a unique identifier
                                     for each device on any CIP network. Each vendor is responsible for guaranteeing the
                                     uniqueness of the serial number across all of its devices. \n
                                     Usually, this number will be set automatically by the firmware,
                                     if a security memory is available. */

  TLR_UINT8   bMinorRev;        /*!< Minor revision \n

                                     \valueRange
                                     1...255 */

  TLR_UINT8   bMajorRev;        /*!< Major revision \n

                                     \valueRange
                                     1...127 */

  TLR_UINT8   abDeviceName[32]; /*!< Device name\n

                                     \description
                                     This text string should represent a short description of the product/product family represented
                                     by the product code. The same product code may have a variety of product name
                                     strings.\n\n
                                     The first byte indicates the name length, byte
                                     2-31 contain the actual characters of the device name.*/

  TLR_UINT32  ulInputAssInstance;   /*!< Instance number of input assembly\n

                                     \valueRange \n\n
                                     Instances of the Assembly Object are divided into the following address ranges to \n
                                     provide for extensions to device profiles \n\n
                                     0x00000001 - 0x00000063 : Open (static assemblies defined in device profile)       \n
                                     0x00000064 - 0x000000C7 : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x000000C8 - 0x000002FF : Open (static assemblies defined in device profile)       \n
                                     0x00000300 - 0x000004FF : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x00000500 - 0x000FFFFF : Open (static assemblies defined in device profile)      \n
                                     0x00100000 - 0xFFFFFFFF : Reserved by CIP for future use.

                                     \description
                                     This parameter defines the instance number of the input assembly.

                                     */

  TLR_UINT32  ulInputAssFlags;      /*!< Input assembly flags\n

                                      \valueRange \n

                                       - <b> Bit 0:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 1:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 2:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 3:</b> \n
                                         If set, the assembly data is modeless
                                         (i.e. it does <b>not</b> contain run/idle information) \n\n

                                       - <b> Bit 4:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 5:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 6:</b> \n
                                         This flag decides whether the data that is mapped into the
                                         DPM memory area is cleared upon closing of
                                         the connection or whether the last sent/received data is left
                                         unchanged in the memory.
                                         If the bit is set the data will be left unchanged.\n\n
                                     */


  TLR_UINT32  ulOutputAssInstance;  /*!< Instance number of output assembly\n

                                     \valueRange \n\n
                                     Instances of the Assembly Object are divided into the following address ranges to \n
                                     provide for extensions to device profiles \n\n
                                     0x00000001 - 0x00000063 : Open (static assemblies defined in device profile)       \n
                                     0x00000064 - 0x000000C7 : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x000000C8 - 0x000002FF : Open (static assemblies defined in device profile)       \n
                                     0x00000300 - 0x000004FF : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x00000500 - 0x000FFFFF : Open (static assemblies defined in device profile)      \n
                                     0x00100000 - 0xFFFFFFFF : Reserved by CIP for future use.

                                     \description
                                     This parameter defines the instance number of the output assembly.

                                     */

  TLR_UINT32   ulOutputAssFlags;     /*!< Output assembly flags\n

                                      \valueRange \n
                                      See description of ulInputAssFlags
                                     */

  EIP_DPMINTF_QOS_CONFIG_T tQoS_Config; /*!< Quality of Service \n

                                          \description

                                           This parameter set configures the Quality of Service Object
                                           (CIP Id 0x48).
                                           For more information about specific parameters see command
                                           EIP_OBJECT_CFG_QOS_REQ.

                                         */

  TLR_UINT32   ulNameServer;         /*!< Name Server 1\n

                                       \description
                                        This parameter corresponds to an entry of attribute 5 of the
                                        TCP Interface Object (CIP Id 0xF5).

                                        \valueRange \n
                                        Default value: 0.0.0.0
                                     */

  TLR_UINT32   ulNameServer_2;       /*!< Name Server 2\n

                                       \description
                                        This parameter corresponds to an entry of attribute 5 of the
                                        TCP Interface Object (CIP Id 0xF5).

                                        \valueRange \n
                                        Default value: 0.0.0.0
                                      */

  TLR_UINT8    abDomainName[48 + 2]; /*!< Domain Name\n

                                       \description
                                        This parameter corresponds to an entry of attribute 5 of the
                                        TCP Interface Object (CIP Id 0xF5).
                                        The first two bytes of the name provide the length of the name.

                                        \valueRange \n
                                        Default value: No Name ("") \n
                                        Max. name length is 48 bytes

                                      */

  TLR_UINT8    abHostName[64+2];     /*!< Host Name\n

                                       \description
                                        This parameter corresponds to attribute 6 of the
                                        TCP Interface Object (CIP Id 0xF5).
                                        The first two bytes of the name provide the length of the name.

                                        \valueRange \n
                                        Default value: No Name ("") \n
                                        Max. name length is 64 bytes
                                      */

  TLR_UINT8    bSelectAcd;           /*!< Select ACD

                                         \description
                                        This parameter corresponds to attribute 10 of the
                                        TCP Interface Object (CIP Id 0xF5).

                                        \valueRange \n
                                        1: ACD on (default) \n
                                        0: ACD off

                                      */

  EIP_DPMINTF_TI_ACD_LAST_CONFLICT_T  tLastConflictDetected; /*!< Last detected conflict\n

                                                               \description
                                                               This parameter corresponds to attribute 11 of the
                                                               TCP Interface Object (CIP Id 0xF5).

                                                               \valueRange \n
                                                               Default: All zero
                                                             */

  TLR_UINT8                           bQuickConnectFlags; /*!< Quick Connect flags \n

                                                               \description
                                                               This parameter enables/disables the Quick Connect
                                                               functionality within the stack.
                                                               This affects the TCP Interface Object (0xF5)
                                                               attribute 12. \n\n
                                                               \Note: This functionality needs special hardware settings (e.g. fast
                                                               flash)

                                                               \valueRange \n
                                                               See: \ref EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE
                                                               and  \ref EIP_OBJECT_QC_FLAGS_ENABLE_QC

                                                               <b>Examples:</b>\n\n
                                                               Do not support Quick Connect:\n
                                                               Set to zero \n\n

                                                               Support Quick Connect - Quick Connect disabled:\n
                                                               Set only flag \ref EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE
                                                               in order to activate the Quick Connect attribute within the object.\n\n

                                                               Support Quick Connect - Quick Connect enabled:\n
                                                               Set flag \ref EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE
                                                               and flag \ref EIP_OBJECT_QC_FLAGS_ENABLE_QC in order to
                                                               activate the attribute and simultaneously enable the
                                                               Quick Connection functionality.\n\n
                                                             */


  /* New parameters for packet V2 start here **************/

  TLR_UINT8                           abAdminState[2];       /*!< Admin State \n

                                                               \description
                                                               This parameter corresponds to attribute 9 of the
                                                               Ethernet Link Object (CIP Id 0xFF).
                                                               The Admin State attribute shall allow administrative
                                                               setting of the interface state. The interface (PHYs) can be
                                                               enabled or disabled.
                                                               Each array entry stands for one ethernet port.
                                                               This attribute shall be stored in non-volatile memory.

                                                               \valueRange \n
                                                               0x01: Interface enabled
                                                               0x02: Interface disabled
                                                               Default: Both entries 0x01 (enabled)
                                                             */

}__PACKED_POST  EIP_APS_CONFIGURATION_PARAMETER_SET_V2_T;

#define EIP_APS_CONFIGURATION_PARAMETER_SET_V2_SIZE (sizeof(EIP_APS_CONFIGURATION_PARAMETER_SET_V2_T) )

/*#####################################################################################*/
#define EIP_APS_CONFIGURATION_PARAMETER_SET_V3         3

typedef __PACKED_PRE struct EIP_APS_CONFIGURATION_PARAMETER_SET_V3_Ttag
{

  TLR_UINT32  ulSystemFlags;    /*!< Reserved for IO status */
  TLR_UINT32  ulWdgTime;        /*!< Watch dog time (in milliseconds) <br>

                                     \valueRange
                                     0, 20...65535\n
                                     Default: 1000

                                     \description
                                     Value 0 switches off the watch dog */

  TLR_UINT32  ulInputLen;       /*!< Length of input data (Input Assembly)\n

                                     \valueRange
                                     0...504 \n
                                     Default: 16

                                     \description
                                     Defines the input data size and corresponds directly
                                     to the input assembly instance provided by ulInputAssInstance */
  TLR_UINT32  ulOutputLen;      /*!< Length of Output data (Output Assembly)\n

                                     \valueRange
                                     0...504 \n
                                     Default: 16

                                     \description
                                     Defines the output data size and corresponds directly
                                     to the input assembly instance provided by ulOutputAssInstance */

  TLR_UINT32  ulTcpFlag;        /*!< TCP configuration flags\n

                                     \valueRange
                                     Default: 0x00000410 (DHCP and Auto-Negotiation)

                                     \description
                                     For further information see TCPIP-Manual */
  TLR_UINT32  ulIpAddr;         /*!< IP address \n
                                     \valueRange
                                     All valid IP addresses\n
                                     Default: 0.0.0.0 */
  TLR_UINT32  ulNetMask;        /*!< Network mask \n

                                     \valueRange
                                     All valid masks\n
                                     Default: 0.0.0.0 */
  TLR_UINT32  ulGateway;        /*!< Gateway address \n

                                     \valueRange
                                     All valid IP addresses\n
                                     Default: 0.0.0.0 */

  TLR_UINT16  usVendId;         /*!< CIP vendor identification \n

                                     \valueRange
                                     1...65535 \n
                                     Default: 283 (Hilscher GmbH)

                                     \description
                                     This is an identification number for
                                     the manufacturer of an EtherNet/IP device.
                                     Vendor IDs are managed by ODVA.
                                     The value zero is not valid */
  TLR_UINT16  usProductType;    /*!< CIP device type \n

                                     \valueRange
                                     Publicly defined: 0x00 - 0x64    \n
                                     Vendor specific: 0x64 - 0xC7     \n
                                     Reserved by CIP: 0xC8 - 0xFF     \n
                                     Publicly defined: 0x100 - 0x2FF  \n
                                     Vendor specific: 0x300 - 0x4FF   \n
                                     Reserved by CIP: 0x500 - 0xFFFF  \n\n
                                     Default: 0x0C (Communication Device)

                                     \description
                                     The list of device types is managed by ODVA.
                                     It is used to identify the device profile that a
                                     particular product is using. Device profiles
                                     define minimum requirements a device must
                                     implement as well as common options. */
  TLR_UINT16  usProductCode;    /*!< Product code \n

                                     \valueRange
                                     1...65535

                                     \description
                                     The vendor assigned Product Code identifies a particular product within a device type. Each
                                     vendor assigns this code to each of its products. The Product Code typically maps to one or
                                     more catalog/model numbers. Products shall have different codes if their configuration and/or
                                     runtime options are different. Such devices present a different logical view to the network. On
                                     the other hand for example, two products that are the same except for their color or mounting
                                     feet are the same logically and may share the same product code.
                                     The value zero is not valid. */

  TLR_UINT32  ulSerialNumber;   /*!< Serial number \n

                                     \valueRange
                                     0x00000000... 0xFFFFFFFF

                                     \description
                                     This attribute is a number used in conjunction with the Vendor ID to form a unique identifier
                                     for each device on any CIP network. Each vendor is responsible for guaranteeing the
                                     uniqueness of the serial number across all of its devices. \n
                                     Usually, this number will be set automatically by the firmware,
                                     if a security memory is available. */

  TLR_UINT8   bMinorRev;        /*!< Minor revision \n

                                     \valueRange
                                     1...255 */

  TLR_UINT8   bMajorRev;        /*!< Major revision \n

                                     \valueRange
                                     1...127 */

  TLR_UINT8   abDeviceName[32]; /*!< Device name\n

                                     \description
                                     This text string should represent a short description of the product/product family represented
                                     by the product code. The same product code may have a variety of product name
                                     strings.\n\n
                                     The first byte indicates the name length, byte
                                     2-31 contain the actual characters of the device name.*/

  TLR_UINT32  ulInputAssInstance;   /*!< Instance number of input assembly\n

                                     \valueRange \n\n
                                     Instances of the Assembly Object are divided into the following address ranges to \n
                                     provide for extensions to device profiles \n\n
                                     0x00000001 - 0x00000063 : Open (static assemblies defined in device profile)       \n
                                     0x00000064 - 0x000000C7 : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x000000C8 - 0x000002FF : Open (static assemblies defined in device profile)       \n
                                     0x00000300 - 0x000004FF : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x00000500 - 0x000FFFFF : Open (static assemblies defined in device profile)      \n
                                     0x00100000 - 0xFFFFFFFF : Reserved by CIP for future use.

                                     \description
                                     This parameter defines the instance number of the input assembly.

                                     */

  TLR_UINT32  ulInputAssFlags;      /*!< Input assembly flags\n

                                      \valueRange \n

                                       - <b> Bit 0:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 1:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 2:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 3:</b> \n
                                         If set, the assembly data is modeless
                                         (i.e. it does <b>not</b> contain run/idle information) \n\n

                                       - <b> Bit 4:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 5:</b> \n
                                         This flag is used internally and must be set to 0 \n\n

                                       - <b> Bit 6:</b> \n
                                         This flag decides whether the data that is mapped into the
                                         DPM memory area is cleared upon closing of
                                         the connection or whether the last sent/received data is left
                                         unchanged in the memory.
                                         If the bit is set the data will be left unchanged.\n\n
                                     */


  TLR_UINT32  ulOutputAssInstance;  /*!< Instance number of output assembly\n

                                     \valueRange \n\n
                                     Instances of the Assembly Object are divided into the following address ranges to \n
                                     provide for extensions to device profiles \n\n
                                     0x00000001 - 0x00000063 : Open (static assemblies defined in device profile)       \n
                                     0x00000064 - 0x000000C7 : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x000000C8 - 0x000002FF : Open (static assemblies defined in device profile)       \n
                                     0x00000300 - 0x000004FF : Vendor Specific static assemblies and dynamic assemblies \n
                                     0x00000500 - 0x000FFFFF : Open (static assemblies defined in device profile)      \n
                                     0x00100000 - 0xFFFFFFFF : Reserved by CIP for future use.

                                     \description
                                     This parameter defines the instance number of the output assembly.

                                     */

  TLR_UINT32   ulOutputAssFlags;     /*!< Output assembly flags\n

                                      \valueRange \n
                                      See description of ulInputAssFlags
                                     */

  EIP_DPMINTF_QOS_CONFIG_T tQoS_Config; /*!< Quality of Service \n

                                          \description

                                           This parameter set configures the Quality of Service Object
                                           (CIP Id 0x48).
                                           For more information about specific parameters see command
                                           EIP_OBJECT_CFG_QOS_REQ.

                                         */

  TLR_UINT32   ulNameServer;         /*!< Name Server 1\n

                                       \description
                                        This parameter corresponds to an entry of attribute 5 of the
                                        TCP Interface Object (CIP Id 0xF5).

                                        \valueRange \n
                                        Default value: 0.0.0.0
                                     */

  TLR_UINT32   ulNameServer_2;       /*!< Name Server 2\n

                                       \description
                                        This parameter corresponds to an entry of attribute 5 of the
                                        TCP Interface Object (CIP Id 0xF5).

                                        \valueRange \n
                                        Default value: 0.0.0.0
                                      */

  TLR_UINT8    abDomainName[48 + 2]; /*!< Domain Name\n

                                       \description
                                        This parameter corresponds to an entry of attribute 5 of the
                                        TCP Interface Object (CIP Id 0xF5).
                                        The first two bytes of the name provide the length of the name.

                                        \valueRange \n
                                        Default value: No Name ("") \n
                                        Max. name length is 48 bytes

                                      */

  TLR_UINT8    abHostName[64+2];     /*!< Host Name\n

                                       \description
                                        This parameter corresponds to attribute 6 of the
                                        TCP Interface Object (CIP Id 0xF5).
                                        The first two bytes of the name provide the length of the name.

                                        \valueRange \n
                                        Default value: No Name ("") \n
                                        Max. name length is 64 bytes
                                      */

  TLR_UINT8    bSelectAcd;           /*!< Select ACD

                                         \description
                                        This parameter corresponds to attribute 10 of the
                                        TCP Interface Object (CIP Id 0xF5).

                                        \valueRange \n
                                        1: ACD on (default) \n
                                        0: ACD off

                                      */

  EIP_DPMINTF_TI_ACD_LAST_CONFLICT_T  tLastConflictDetected; /*!< Last detected conflict\n

                                                               \description
                                                               This parameter corresponds to attribute 11 of the
                                                               TCP Interface Object (CIP Id 0xF5).

                                                               \valueRange \n
                                                               Default: All zero
                                                             */

  TLR_UINT8                           bQuickConnectFlags; /*!< Quick Connect flags \n

                                                               \description
                                                               This parameter enables/disables the Quick Connect
                                                               functionality within the stack.
                                                               This affects the TCP Interface Object (0xF5)
                                                               attribute 12. \n\n
                                                               \Note: This functionality needs special hardware settings (e.g. fast
                                                               flash)

                                                               \valueRange \n
                                                               See: \ref EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE
                                                               and  \ref EIP_OBJECT_QC_FLAGS_ENABLE_QC

                                                               <b>Examples:</b>\n\n
                                                               Do not support Quick Connect:\n
                                                               Set to zero \n\n

                                                               Support Quick Connect - Quick Connect disabled:\n
                                                               Set only flag \ref EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE
                                                               in order to activate the Quick Connect attribute within the object.\n\n

                                                               Support Quick Connect - Quick Connect enabled:\n
                                                               Set flag \ref EIP_OBJECT_QC_FLAGS_ACTIVATE_ATTRIBUTE
                                                               and flag \ref EIP_OBJECT_QC_FLAGS_ENABLE_QC in order to
                                                               activate the attribute and simultaneously enable the
                                                               Quick Connection functionality.\n\n
                                                             */


  /* New parameters for packet V2 start here **************/

  TLR_UINT8                           abAdminState[2];       /*!< Admin State \n

                                                               \description
                                                               This parameter corresponds to attribute 9 of the
                                                               Ethernet Link Object (CIP Id 0xFF).
                                                               The Admin State attribute shall allow administrative
                                                               setting of the interface state. The interface (PHYs) can be
                                                               enabled or disabled.
                                                               Each array entry stands for one ethernet port.
                                                               This attribute shall be stored in non-volatile memory.

                                                               \valueRange \n
                                                               0x01: Interface enabled
                                                               0x02: Interface disabled
                                                               Default: Both entries 0x01 (enabled)
                                                             */

  /* New parameters for packet V3 start here **************/

  TLR_UINT8                            abReserved[9];         /* Reserved, set to zero */

  TLR_UINT16                          usEncapInactivityTimeout;  /*!< Encapsulation Inactivity Timeout \n

                                                                 \description
                                                                 This parameter corresponds to attribute 13 of the
                                                                 TCP/IP Interface Object (CIP Id 0xF5).
                                                                 The Encapsulation Inavtivity Timeout is used to close socketes when the
                                                                 defined time (seconds) eclapsed without Encapsulation activity.
                                                                 This attribute shall be stored in non-volatile memory.

                                                                 \valueRange \n
                                                                 0 - disabled
                                                                 1 - 3600 seconds
                                                                 Default: 120 seconds
                                                                 */

}__PACKED_POST  EIP_APS_CONFIGURATION_PARAMETER_SET_V3_T;

#define EIP_APS_CONFIGURATION_PARAMETER_SET_V3_SIZE (sizeof(EIP_APS_CONFIGURATION_PARAMETER_SET_V3_T) )

/*#####################################################################################*/

/* Request Packet */

typedef __PACKED_PRE struct EIP_APS_SET_CONFIGURATION_PARAMETERS_REQ_Ttag
{
  TLR_UINT32  ulParameterVersion;  /*!< Version related to the following configuration union */

  __PACKED_PRE union
  {
    EIP_APS_CONFIGURATION_PARAMETER_SET_V1_T tV1;
    EIP_APS_CONFIGURATION_PARAMETER_SET_V2_T tV2;
    EIP_APS_CONFIGURATION_PARAMETER_SET_V3_T tV3;
  }__PACKED_POST unConfig;

}__PACKED_POST  EIP_APS_SET_CONFIGURATION_PARAMETERS_REQ_T;


typedef struct EIP_APS_PACKET_SET_CONFIGURATION_PARAMETERS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                        tHead;
  EIP_APS_SET_CONFIGURATION_PARAMETERS_REQ_T tData;

} EIP_APS_PACKET_SET_CONFIGURATION_PARAMETERS_REQ_T;

#define EIP_APS_SET_CONFIGURATION_PARAMETERS_REQ_SIZE   4 /* Basic size of request packet.
                                                             The size of the following parameter union needs to be added. */

/*#####################################################################################*/

/* Confirmation Packet */

typedef __PACKED_PRE struct EIP_APS_SET_CONFIGURATION_PARAMETERS_CNF_Ttag
{
  TLR_UINT32  ulPacketVersion;  /*!< Version related to the following union entry */

  __PACKED_PRE union
  {
    EIP_APS_CONFIGURATION_PARAMETER_SET_V1_T tV1;
    EIP_APS_CONFIGURATION_PARAMETER_SET_V2_T tV2;
    EIP_APS_CONFIGURATION_PARAMETER_SET_V3_T tV3;
  }__PACKED_POST unConfig;

}__PACKED_POST  EIP_APS_SET_CONFIGURATION_PARAMETERS_CNF_T;


typedef struct EIP_APS_PACKET_SET_CONFIGURATION_PARAMETERS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                        tHead;
  EIP_APS_SET_CONFIGURATION_PARAMETERS_CNF_T tData;
} EIP_APS_PACKET_SET_CONFIGURATION_PARAMETERS_CNF_T;

/*#####################################################################################*/
/*#####################################################################################*/

/*! \defgroup EIP_APS_SET_PARAMETER_REQ_Content Command related contents
 *  \ingroup EIP_APS_SET_PARAMETER_REQ
 * \{ */

#define EIP_APS_PRM_SIGNAL_MS_NS_CHANGE            0x00000001 /*!< This flag enables or disables the notification of
                                                                   the network and module status. Every time the status
                                                                   of the module or network changes packet
                                                                   EIP_APS_MS_NS_CHANGE_IND will be sent to the
                                                                   registered EtherNet/IP Application task.    */

typedef __PACKED_PRE struct EIP_APS_SET_PARAMETER_REQ_Ttag
{
  TLR_UINT32  ulParameterFlags;    /*!< Parameter flags \n

                                       \description
                                       \ref EIP_APS_PRM_SIGNAL_MS_NS_CHANGE\n
                                       If set, this flag enables the notification of
                                       the network and module status. Every time the status
                                       of the module or network changes packet
                                       EIP_APS_MS_NS_CHANGE_IND will be sent to the
                                       registered EtherNet/IP Application task. */

}__PACKED_POST  EIP_APS_SET_PARAMETER_REQ_T;

#define EIP_APS_SET_PARAMETER_REQ_SIZE (sizeof(EIP_APS_SET_PARAMETER_REQ_T))

typedef struct EIP_APS_PACKET_SET_PARAMETER_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  EIP_APS_SET_PARAMETER_REQ_T     tData;
} EIP_APS_PACKET_SET_PARAMETER_REQ_T;

 #define EIP_APS_SET_PARAMETER_CNF_SIZE 0

typedef struct EIP_APS_PACKET_SET_PARAMETER_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;
} EIP_APS_PACKET_SET_PARAMETER_CNF_T;

/*! \} */

/*#####################################################################################*/

/*! \defgroup EIP_APS_MS_NS_CHANGE_IND_Content Command related contents
 *  \ingroup EIP_APS_MS_NS_CHANGE_IND
 * \{ */

typedef __PACKED_PRE struct EIP_APS_MS_NS_CHANGE_IND_Ttag
{
  TLR_UINT32  ulModuleStatus;     /*!< Module Status \n

                                       \description
                                       The module status describes the current state of the
                                       corresponding MS-LED (provided that it is connected).
                                       See \ref EIP_HW_MODUL_STATUS_E for more details. */

  TLR_UINT32  ulNetworkStatus;     /*!< Network Status \n

                                       \description
                                       The network status describes the current state of the
                                       corresponding NS-LED (provided that it is connected).
                                       See \ref EIP_HW_NET_STATUS_E for more details. */

}__PACKED_POST  EIP_APS_MS_NS_CHANGE_IND_T;

#define EIP_APS_MS_NS_CHANGE_IND_SIZE (sizeof(EIP_APS_MS_NS_CHANGE_IND_T))

typedef struct EIP_APS_PACKET_MS_NS_CHANGE_IND_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  EIP_APS_MS_NS_CHANGE_IND_T      tData;
} EIP_APS_PACKET_MS_NS_CHANGE_IND_T;


#define EIP_APS_MS_NS_CHANGE_RES_SIZE 0

typedef struct EIP_APS_PACKET_MS_NS_CHANGE_RES_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
} EIP_APS_PACKET_MS_NS_CHANGE_RES_T;

/*! \} */

/*#####################################################################################*/
/*#####################################################################################*/

/*! \defgroup EIP_APS_GET_MS_NS_REQ_Content Command related contents
 *  \ingroup EIP_APS_GET_MS_NS_REQ
 * \{ */

#define EIP_APS_GET_MS_NS_REQ_SIZE       0

typedef struct EIP_APS_PACKET_GET_MS_NS_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
} EIP_APS_PACKET_GET_MS_NS_REQ_T;


typedef __PACKED_PRE struct EIP_APS_GET_MS_NS_CNF_Ttag
{
  TLR_UINT32  ulModuleStatus;     /*!< Module Status \n

                                       \description
                                       The module status describes the current state of the
                                       corresponding MS-LED (provided that it is connected).
                                       See \ref EIP_HW_MODUL_STATUS_E for more details. */

  TLR_UINT32  ulNetworkStatus;     /*!< Network Status \n

                                       \description
                                       The network status describes the current state of the
                                       corresponding NS-LED (provided that it is connected).
                                       See \ref EIP_HW_NET_STATUS_E for more details. */

}__PACKED_POST  EIP_APS_GET_MS_NS_CNF_T;

#define EIP_APS_GET_MS_NS_CNF_SIZE  sizeof(EIP_APS_GET_MS_NS_CNF_T)

typedef struct EIP_APS_PACKET_GET_MS_NS_CNF_Ttag
{
  TLR_PACKET_HEADER_T      tHead;
  EIP_APS_GET_MS_NS_CNF_T  tData;

} EIP_APS_PACKET_GET_MS_NS_CNF_T;

/*! \} */

/*################################################################################*/
/* RCX_SET_FW_PARAMETER_REQ/CNF                                                   */
/*################################################################################*/

/* new packets that are defined at rcX */
#ifndef RCX_SET_FW_PARAMETER_REQ

#define RCX_SET_FW_PARAMETER_REQ                      0x00002F86
#define RCX_SET_FW_PARAMETER_CNF                      0x00002F87

typedef __TLR_PACKED_PRE struct RCX_SET_FW_PARAMETER_REQ_DATA_Ttag
{
  TLR_UINT32 ulParameterID;
  TLR_UINT32 ulParameterLen;
  TLR_UINT8  abParameter[4];  /* padded to DWORD boundary*/
} __TLR_PACKED_POST RCX_SET_FW_PARAMETER_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct RCX_SET_FW_PARAMETER_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  RCX_SET_FW_PARAMETER_REQ_DATA_T tData;
} __TLR_PACKED_POST RCX_SET_FW_PARAMETER_REQ_T;

#define RCX_SET_FW_PARAMETER_REQ_SIZE (sizeof(RCX_SET_FW_PARAMETER_REQ_DATA_T) - 4)


/***** confirmation packet *****/
typedef TLR_EMPTY_PACKET_T  RCX_SET_FW_PARAMETER_CNF_T;

#define RCX_SET_FW_PARAMETER_CNF_SIZE     (0)
#endif

/*################################################################################*/
/* RCX_GET_FW_PARAMETER_REQ/CNF                                                   */
/*################################################################################*/

#ifndef RCX_GET_FW_PARAMETER_REQ

#define RCX_GET_FW_PARAMETER_REQ                      0x00002F88
#define RCX_GET_FW_PARAMETER_CNF                      0x00002F89

typedef __TLR_PACKED_PRE struct RCX_GET_FW_PARAMETER_REQ_DATA_Ttag
{
  TLR_UINT32 ulParameterID;
} __TLR_PACKED_POST RCX_GET_FW_PARAMETER_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct RCX_GET_FW_PARAMETER_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  RCX_GET_FW_PARAMETER_REQ_DATA_T tData;
} __TLR_PACKED_POST RCX_GET_FW_PARAMETER_REQ_T;

#define RCX_GET_FW_PARAMETER_REQ_SIZE (sizeof(RCX_GET_FW_PARAMETER_REQ_DATA_T))


/***** confirmation packet *****/

typedef RCX_SET_FW_PARAMETER_REQ_T   RCX_GET_FW_PARAMETER_CNF_T;

#define RCX_GET_FW_PARAMETER_CNF_SIZE RCX_SET_FW_PARAMETER_REQ_SIZE
#endif


/*################################################################################*/
/* RCX_LINK_STATUS_CHANGE_IND/RES                                                 */
/*################################################################################*/
#ifndef RCX_LINK_STATUS_CHANGE_IND

/*! \addtogroup RCX_LINK_STATUS_CHANGE_IND_Content
 * \{ */
#define RCX_LINK_STATUS_CHANGE_IND                      0x00002F8A
#define RCX_LINK_STATUS_CHANGE_RES                      0x00002F8B
/*! \}*/


/*! \defgroup RCX_LINK_STATUS_CHANGE_IND_Content Command related contents
 *  \ingroup RCX_LINK_STATUS_CHANGE_IND
 * \{ */
/***** indication packet *****/

typedef __PACKED_PRE struct RCX_LINK_STATUS_Ttag
{

  TLR_UINT32  ulPort;           /*!< Port number\n\n

                                     \valueRange \n
                                     0: Port 1 \n
                                     1: Port 2 */

  TLR_BOOLEAN32 fIsFullDuplex;  /*!< Duplex mode\n\n

                                     \valueRange \n
                                     0: Half duplex \n
                                     1: Full Duplex */

  TLR_BOOLEAN32 fIsLinkUp;      /*!< Link status\n\n

                                     \valueRange \n
                                     0: Link is down \n
                                     1: Link is up */

  TLR_UINT32  ulSpeed;          /*!< Port speed\n\n

                                     \valueRange \n
                                     0:   (No link) \n
                                     10:  10MBit    \n
                                     100: 100MBit   \n */

} __PACKED_POST RCX_LINK_STATUS_T;


typedef __TLR_PACKED_PRE struct RCX_LINK_STATUS_CHANGE_IND_DATA_Ttag
{
  RCX_LINK_STATUS_T  atLinkData[2]; /*!< Link status data (see \ref RCX_LINK_STATUS_Ttag)*/

} __TLR_PACKED_POST RCX_LINK_STATUS_CHANGE_IND_DATA_T;

typedef __TLR_PACKED_PRE struct RCX_LINK_STATUS_CHANGE_IND_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  RCX_LINK_STATUS_CHANGE_IND_DATA_T tData;
} __TLR_PACKED_POST RCX_LINK_STATUS_CHANGE_IND_T;

#define RCX_LINK_STATUS_CHANGE_IND_SIZE (sizeof(RCX_LINK_STATUS_CHANGE_IND_DATA_T))


/***** response packet *****/
typedef struct RCX_LINK_STATUS_CHANGE_RES_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
} RCX_LINK_STATUS_CHANGE_RES_T;

#define RCX_LINK_STATUS_CHANGE_RES_SIZE   (0)

#endif
/*! \}*/


/*################################################################################*/
/*################################################################################*/

#define PID_EIP_IP_CONFIGURATION  0x3000A001 /* EtherNet/IP Address Settings      */
#define PID_EIP_IP_CONFIGCONTROL  0x3000A002 /* EtherNet/IP Configuration Control */

typedef struct PID_EIP_IP_CONFIGURATION_Ttag
{
  TLR_UINT32 ulIP;
  TLR_UINT32 ulNetmask;
  TLR_UINT32 ulGateway;
}PID_EIP_IP_CONFIGURATION_T;


#define PRM_CFGCTRL_STORED_CFG  0
#define PRM_CFGCTRL_DHCP        1
#define PRM_CFGCTRL_BOOTP       2
#define PRM_CFGCTRL_FIXIP       3

typedef struct PID_EIP_IP_CONFIGCONTROL_Ttag
{
  TLR_UINT32 ulConfigurationControl;
} PID_EIP_IP_CONFIGCONTROL_T;

/*#####################################################################################*/
/*#####################################################################################*/
/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(EIP_DPMINTF_PUBLIC)
#endif


/***************************************************************************************/
/* Eip DpmIntf public, prototypes */

/***************************************************************************************/
#endif /* #ifndef __EIP_DPMINTF_PUBLIC_H */
